using System;
using System.Data;
using System.Data.SqlClient;
using DAILYCONTROL = gov.va.med.vbecs.Common.VbecsTables.DailyControl;
using STOREDPROC = gov.va.med.vbecs.Common.VbecsStoredProcs;
using gov.va.med.vbecs.Common;

namespace gov.va.med.vbecs.DAL
{
	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Carrie Van Stedum</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>03/12/2003</CreationDate>
	///<Note>Note: The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>
	///	Data access layer class implementing database read/write 
	///	functionality for daily control related data.
	///</summary>

	public class DailyControl
	{
		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/15/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1158"> 
		///		<ExpectedInput>
		///		Rack DataTable 
		///		Reagent DataTable 
		///		Control DataTable 
		///		LastUpdatefUnction 
		///		IsInsert
		///		</ExpectedInput>
		///		<ExpectedOutput>true</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1159"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///<summary>Saves all daily control data from a DataTables passed in.</summary>
		///<param name="commercialIndicator"></param>
		///<param name="dtRackData">DataTable containing a rack data</param>
		///<param name="dtReagentData">DataTable containing a reagents data</param>
		///<param name="lastUpdateFunctionId">UC or calling method</param>
		///<param name="dtInsertDC">DataTable with Insert Values</param>
		///<param name="dtUpdateDC">DataTable with Update Values</param>
		///<returns>True on success. Otherwise - false.</returns>
		public static bool SaveAllDailyControlData
		(
			bool commercialIndicator,
			System.Data.DataTable dtRackData, 
			System.Data.DataTable dtReagentData, 
			Common.UpdateFunction lastUpdateFunctionId, 
			System.Data.DataTable dtInsertDC,
			System.Data.DataTable dtUpdateDC
		)
		{
			System.Collections.ArrayList sprocList = new System.Collections.ArrayList();
			System.Collections.ArrayList dtList = new System.Collections.ArrayList();
			DataTable dtInsertedRacks = new DataTable();
			DataTable dtModifiedRacks = new DataTable();

			//Build the sproc and datatable arrays
			if(dtReagentData.Rows.Count > 0)
			{
				// Data table of racks that may or may not need to be deactivated.
				SqlParameter[] prms =
				{
					new SqlParameter(STOREDPROC.GetDailyControlRack.commercialtemplateindicator, SqlDbType.Bit),
					new SqlParameter(STOREDPROC.GetDailyControlRack.divisioncode, SqlDbType.VarChar)
				};
				prms[0].Value = commercialIndicator;
				prms[1].Value = Common.LogonUser.LogonUserDivisionCode;

				if(dtRackData.DataSet.HasChanges())
				{
					dtInsertedRacks = dtRackData.GetChanges(System.Data.DataRowState.Added);
					dtModifiedRacks = dtRackData.GetChanges(System.Data.DataRowState.Modified);
				}


				//
				System.Data.DataTable dtDeactivateRacks = StoredProcedure.GetData(STOREDPROC.GetDailyControlRack.StoredProcName, prms).Tables[0].Copy();

				//You do not want to change row version or inactivate
				//racks that you will be updating later so remove them here from the deactivate sproc
                dtDeactivateRacks = Common.Utility.AppendLastUpdateInformation( dtDeactivateRacks, lastUpdateFunctionId );
				
				
				System.Data.DataTable dtNewDeactivateRacks = dtDeactivateRacks.Copy();
				if(dtInsertedRacks != null && dtInsertedRacks.Rows.Count > 0)
				{
					foreach(System.Data.DataRow dtRow in dtDeactivateRacks.Rows)
					{
						System.Data.DataRow [] dtRows = dtInsertedRacks.Select("RackGuid = '" + dtRow[Common.VbecsTables.Rack.RackGuid].ToString() + "'");
						if(dtRows.Length > 0)
						{
							foreach(System.Data.DataRow dtRowElement in dtRows)
							{
								System.Data.DataRow [] dtRemoveRows= dtNewDeactivateRacks.Select("RackGuid = '" + dtRowElement[Common.VbecsTables.Rack.RackGuid].ToString() + "'");
								if(dtRemoveRows.Length > 0)
								{
									foreach(System.Data.DataRow dtRemove in dtRemoveRows)
									{
										dtNewDeactivateRacks.Rows.Remove(dtRemove);
									}
								}
							}
						}
					}
				}
				
				
				if(dtModifiedRacks != null && dtModifiedRacks.Rows.Count > 0)
				{
					foreach(System.Data.DataRow dtRow in dtDeactivateRacks.Rows)
					{
						System.Data.DataRow [] dtRows = dtModifiedRacks.Select("RackGuid = '" + dtRow[Common.VbecsTables.Rack.RackGuid].ToString() + "'");
						if(dtRows.Length > 0)
						{
							foreach(System.Data.DataRow dtRowElement in dtRows)
							{
								System.Data.DataRow [] dtRemoveRows= dtNewDeactivateRacks.Select("RackGuid = '" + dtRowElement[Common.VbecsTables.Rack.RackGuid].ToString() + "'");
								if(dtRemoveRows.Length > 0)
								{
									foreach(System.Data.DataRow dtRemove in dtRemoveRows)
									{
										dtNewDeactivateRacks.Rows.Remove(dtRemove);
									}
								}
							}
						}
					}
				}
				
				// The following stored procedure was removed from the update daily
				// control stored procedure and placed in one of it's own.
				sprocList.Add(STOREDPROC.DeactivateDailyControlRack.StoredProcName);
				dtList.Add(dtNewDeactivateRacks);

				//Perform the Updates first (if any) so that Existing Rows can be inactivated -- not sure if it matters anymore tho
				dtList.Add(Common.Utility.AppendLastUpdateInformation(dtUpdateDC, lastUpdateFunctionId));
				sprocList.Add(STOREDPROC.UpdateDailyControl.StoredProcName);

				dtList.Add(Common.Utility.AppendLastUpdateInformation(dtInsertDC, lastUpdateFunctionId));
				sprocList.Add(STOREDPROC.InsertDailyControl.StoredProcName);

				// Retieve list of reagent test parameter records, so we can inactivate them via
				// their rowversions (one at a time)
				SqlParameter[] prms2 =
				{
					new SqlParameter(Common.VbecsStoredProcs.GetConfigureReagentQC.commercialindicator, SqlDbType.Bit),
					new SqlParameter(Common.VbecsStoredProcs.GetConfigureReagentQC.divisioncode, SqlDbType.VarChar)
				};
				prms2[0].Value = System.Convert.ToBoolean(dtReagentData.Rows[0][Common.VbecsTables.ReagentTestParameter.CommercialIndicator]);
				prms2[1].Value = Common.LogonUser.LogonUserDivisionCode;
				//
				System.Data.DataTable dt = StoredProcedure.GetData(Common.VbecsStoredProcs.GetConfigureReagentQC.StoredProcName, prms2).Tables[0].Copy();
					
				//InactivateConfigurableReagentQC  Set all the reagent test parameter records to inactive
				sprocList.Add(STOREDPROC.UpdateConfigureReagentQC.StoredProcName);
				dtList.Add(Common.Utility.AppendLastUpdateInformation(dt, lastUpdateFunctionId));
				
				sprocList.Add(STOREDPROC.InsertReagentTestParameter.StoredProcName);
				dtList.Add(Common.Utility.AppendLastUpdateInformation(dtReagentData, lastUpdateFunctionId));

				if(dtRackData.DataSet.HasChanges())
				{
					dtInsertedRacks = dtRackData.GetChanges(System.Data.DataRowState.Added);
					dtModifiedRacks = dtRackData.GetChanges(System.Data.DataRowState.Modified);

					if( dtModifiedRacks != null && dtModifiedRacks.Rows.Count > 0 )
					{
						sprocList.Add(STOREDPROC.UpdateConfigurableRackQC.StoredProcName);
						dtList.Add(Common.Utility.AppendLastUpdateInformation(dtModifiedRacks, lastUpdateFunctionId));
					}

					if( dtInsertedRacks != null && dtInsertedRacks.Rows.Count > 0 )
					{
						dtInsertedRacks.Columns.Remove( Common.VbecsTables.Rack.RackName );
						dtInsertedRacks.Columns.Remove( Common.VbecsTables.Rack.DivisionCode );
						//
						sprocList.Add(STOREDPROC.ActivateDailyControlRack.StoredProcName);
						dtList.Add(Common.Utility.AppendLastUpdateInformation(dtInsertedRacks, lastUpdateFunctionId));
					}
				}
			
				
			}

			return ( (new StoredProcedure()).TransactionalGetValue(sprocList, dtList) == 0 );
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/15/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1160"> 
		///		<ExpectedInput>DailyControl Guid</ExpectedInput>
		///		<ExpectedOutput>DataTable of DailyControl Details</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1161"> 
		///		<ExpectedInput>Invalid Guid</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// GetDailyControlByGUID
		/// </summary>
		/// <param name="dailyControlGuid">Daily Control GUID</param>
		/// <returns></returns>
		public static DataTable GetDailyControlByGuid(System.Guid dailyControlGuid)
		{
			SqlParameter[] prms =	
			{
				new SqlParameter(STOREDPROC.GetConfigureDailyQCByGuid.existingdailycontrolguid, System.Data.SqlDbType.UniqueIdentifier),
				new SqlParameter(STOREDPROC.GetConfigureDailyQCByGuid.divisioncode, System.Data.SqlDbType.Char)
			};

			prms[0].Value = dailyControlGuid;
			prms[1].Value = Common.LogonUser.LogonUserDivisionCode;
				
			return StoredProcedure.GetDataTable( STOREDPROC.GetConfigureDailyQCByGuid.StoredProcName, prms );
		}
		
		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/15/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8201"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>Data table with populated rack data</ExpectedOutput>
		///</Case>
		///<Case type="1" testid ="8202"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
	    ///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		///     Gets all racks for a division
		/// </summary>
		/// 
		/// <returns>
		///     A System.Data.DataTable value...
		/// </returns>
		public static DataTable GetAllRacks()
		{
			SqlParameter[] prms =
				{
					new SqlParameter( STOREDPROC.GetRacks.divisioncode, System.Data.SqlDbType.VarChar )
				};
			
			prms[0].Value = Common.LogonUser.LogonUserDivisionCode;
				
			return StoredProcedure.GetDataTable( STOREDPROC.GetRacks.StoredProcName, prms);
		}

				
		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/15/2004</CreationDate>
		///<TestCases>
		///<Case type="0" testid ="8203"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>A data table with partiall completed QC results</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="8204"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		///  Returns a datatable with partially completed QC test results   
		/// </summary>
		/// 
		/// <returns>
		///     A System.Data.DataTable value...
		/// </returns>
		public static DataTable GetPartiallyCompletedQC()
		{
			SqlParameter[] prms =
				{
					new SqlParameter( STOREDPROC.GetPartiallyCompletedQC.divisioncode, System.Data.SqlDbType.VarChar ),
					new SqlParameter( STOREDPROC.GetPartiallyCompletedQC.testdatetime, System.Data.SqlDbType.DateTime)
				};
			
			prms[0].Value = Common.LogonUser.LogonUserDivisionCode;
			prms[1].Value = DAL.VbecsDateTime.GetDivisionCurrentDateTime(Common.LogonUser.LogonUserDivisionCode);
				
			return StoredProcedure.GetDataTable( STOREDPROC.GetPartiallyCompletedQC.StoredProcName, prms);
		}

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/15/2004</CreationDate>
		///<TestCases>
		///<Case type="0" testid ="8205"> 
		///		<ExpectedInput>true</ExpectedInput>
		///		<ExpectedOutput>An empty data table with established columns but no rows</ExpectedOutput>
		///	</Case>
		///
		///
		///
		///<Case type="1" testid ="8206"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// spInsertDailyControl, spUpdateDailyControl
		/// </summary>
		/// <param name="isUpdate"></param>
		/// <returns></returns>
		public static DataTable GetEmptyDailyControlTableSchema(bool isUpdate)
		{
			DataTable dtDailyControl = new System.Data.DataTable(DAILYCONTROL.TableName);

			dtDailyControl.Columns.Add(DAILYCONTROL.DailyControlGuid, typeof(System.Guid));
			dtDailyControl.Columns.Add(DAILYCONTROL.NumberOfRacks, typeof(int));
			dtDailyControl.Columns.Add(DAILYCONTROL.RackNamesIndicator, typeof(bool));
			dtDailyControl.Columns.Add(DAILYCONTROL.DailyAlertTime, typeof(System.DateTime));
			dtDailyControl.Columns.Add(DAILYCONTROL.CommercialTemplateIndicator, typeof(bool));
			dtDailyControl.Columns.Add(DAILYCONTROL.PrimaryEnhancementMediaId, typeof(int));
			dtDailyControl.Columns.Add(DAILYCONTROL.SecondaryEnhancementMediaId, typeof(int));
			dtDailyControl.Columns.Add(DAILYCONTROL.Comments, typeof(string));
			dtDailyControl.Columns.Add(DAILYCONTROL.DivisionCode, typeof(string));
			dtDailyControl.Columns.Add(DAILYCONTROL.RecordStatusCode, typeof(string));
			dtDailyControl.Columns.Add(DAILYCONTROL.LastUpdateFunctionId, typeof(int));

			if (isUpdate)
			{
				dtDailyControl.Columns.Add(DAILYCONTROL.RowVersion , typeof(byte[]));
			}

			return dtDailyControl;
		}


		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/15/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1164"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>The data table containing daily controls for the division</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1854"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Retrieves a list of daily controls from database
		/// </summary>
		/// <returns></returns>
		public static DataTable GetDailyControl()
		{
			SqlParameter[] prms =
				{
					new SqlParameter( STOREDPROC.GetDailyControl.divisioncode, System.Data.SqlDbType.VarChar ),
					new SqlParameter( STOREDPROC.GetDailyControl.recordstatuscode, System.Data.SqlDbType.Char ),

				};
			
			prms[0].Value = Common.LogonUser.LogonUserDivisionCode;
			prms[1].Value = Common.Utility.GetRecordStatusCodeCharFromEnum(Common.RecordStatusCode.Active);
				
			return StoredProcedure.GetDataTable( STOREDPROC.GetDailyControl.StoredProcName, prms);
		}



	}
}



